<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
/*
Route::get('/', function () {
    return redirect('login');
});
*/

Route::get('/', [App\Http\Controllers\Auth\LoginController::class,'login'])->name('login');
Route::get('login', [App\Http\Controllers\Auth\LoginController::class,'login'])->name('login');
Route::post('authenticate', [App\Http\Controllers\Auth\LoginController::class,'authenticate'])->name('authenticate');
Route::post('logout', [App\Http\Controllers\Auth\LoginController::class,'logout'])->name('logout');
//Route::get('logout', 'Auth\LoginController@logout')->name('logout');


Auth::routes();
Route::group(['middleware' => ['auth']], function() {
	Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
	Route::get('/profile', [App\Http\Controllers\HomeController::class, 'profile'])->name('profile');
	Route::post('/profile', [App\Http\Controllers\HomeController::class, 'profile_update'])->name('profile_update');
	
	Route::post('/setflag', [App\Http\Controllers\TransaksiController::class, 'set_flag']);
	Route::post('/setflag_in', [App\Http\Controllers\TransaksiController::class, 'set_flag_in']);
	Route::post('/undo_flag', [App\Http\Controllers\TransaksiController::class, 'undo_flag']);
	Route::post('/batal', [App\Http\Controllers\TransaksiController::class, 'batal']);
	//transaksi
	
	Route::get('transaksi/vehicle_in', [App\Http\Controllers\TransaksiController::class, 'vehicle_in']);
	Route::post('transaksi/vehicle_inm', [App\Http\Controllers\TransaksiController::class, 'vehicle_in_mgmt']);
	Route::post('transaksi/vehicle_in/detail', [App\Http\Controllers\TransaksiController::class, 'vehicle_in_detail']);
	Route::post('transaksi/vehicle_in/set_carcall', [App\Http\Controllers\TransaksiController::class, 'set_carcall']);
	Route::get('transaksi/vehicle_out', [App\Http\Controllers\TransaksiController::class, 'vehicle_out']);
	Route::post('transaksi/vehicle_outm', [App\Http\Controllers\TransaksiController::class, 'vehicle_out_mgmt']);
	Route::post('transaksi/vehicle_out/detail', [App\Http\Controllers\TransaksiController::class, 'vehicle_out_detail']);
	Route::get('transaksi/settlement', [App\Http\Controllers\TransaksiController::class, 'settlement']);
	Route::post('transaksi/settlement', [App\Http\Controllers\TransaksiController::class, 'settlement_save']);
	Route::get('transaksi/settlement/input/{id}', [App\Http\Controllers\TransaksiController::class, 'settlement_input']);
	Route::get('transaksi/settlement/cetak/{id}', [App\Http\Controllers\TransaksiController::class, 'settlement_cetak']);
	Route::get('transaksi/shift_info', [App\Http\Controllers\TransaksiController::class, 'shift_info']);
	Route::post('transaksi/endshift', [App\Http\Controllers\TransaksiController::class, 'endshift']);
	
	
	
	//laporan
	Route::get('laporan/transaksi_harian', [App\Http\Controllers\LaporanController::class, 'transaksi_harian']);
	Route::post('laporan/transaksi_harian', [App\Http\Controllers\LaporanController::class, 'transaksi_harian_data']);
	Route::get('laporan/settlement', [App\Http\Controllers\LaporanController::class, 'settlement']);
	Route::post('laporan/settlement', [App\Http\Controllers\LaporanController::class, 'settlement_data']);
	Route::get('laporan/transaksi_bulanan', [App\Http\Controllers\LaporanController::class, 'transaksi_bulanan']);
	Route::post('laporan/transaksi_bulanan', [App\Http\Controllers\LaporanController::class, 'transaksi_bulanan_data']);
	
	
	
	//lokasi
	Route::get('konfigurasi/lokasi', [App\Http\Controllers\SiteController::class, 'lokasi']);
	Route::get('konfigurasi/lokasi/add', [App\Http\Controllers\SiteController::class, 'lokasi_add']);
	Route::post('konfigurasi/lokasi', [App\Http\Controllers\SiteController::class, 'lokasi_simpan']);
	Route::get('konfigurasi/lokasi/edit/{id}', [App\Http\Controllers\SiteController::class, 'lokasi_edit']);
	Route::post('konfigurasi/lokasi/update', [App\Http\Controllers\SiteController::class, 'lokasi_update'])->name('lokasi_update');
	
	Route::post('destroy_item', [App\Http\Controllers\TransaksiController::class, 'hapus_item']);
	
	
	//lobby
	Route::get('konfigurasi/lobby', [App\Http\Controllers\LobbyController::class, 'index']);
	Route::get('konfigurasi/lobby/add', [App\Http\Controllers\LobbyController::class, 'lobby_add']);
	Route::post('konfigurasi/lobby', [App\Http\Controllers\LobbyController::class, 'lobby_simpan']);
	Route::get('konfigurasi/lobby/edit/{id}', [App\Http\Controllers\LobbyController::class, 'lobby_edit']);
	Route::post('konfigurasi/lobby/update', [App\Http\Controllers\LobbyController::class, 'lobby_update'])->name('lobby_update');
	
	//paket
	Route::get('konfigurasi/paket', [App\Http\Controllers\PaketController::class, 'index']);
	Route::get('konfigurasi/paket/add', [App\Http\Controllers\PaketController::class, 'paket_add']);
	Route::post('konfigurasi/paket', [App\Http\Controllers\PaketController::class, 'paket_simpan']);
	Route::get('konfigurasi/paket/edit/{id}', [App\Http\Controllers\PaketController::class, 'paket_edit']);
	Route::post('konfigurasi/paket/update', [App\Http\Controllers\PaketController::class, 'paket_update'])->name('lokasi_update');
	
	//petugas valet
	Route::get('konfigurasi/users', [App\Http\Controllers\UsersController::class, 'index']);
	Route::get('konfigurasi/users/add', [App\Http\Controllers\UsersController::class, 'users_add']);
	Route::post('konfigurasi/users/simpan', [App\Http\Controllers\UsersController::class, 'users_simpan']);
	Route::get('konfigurasi/users/edit/{id}', [App\Http\Controllers\UsersController::class, 'users_edit']);
	Route::post('konfigurasi/users/update', [App\Http\Controllers\UsersController::class, 'users_update']);
	
	//admins
	Route::get('konfigurasi/admin', [App\Http\Controllers\AdminController::class, 'admin']);
	Route::get('konfigurasi/admin/add', [App\Http\Controllers\AdminController::class, 'admin_add']);
	Route::post('konfigurasi/admin/simpan', [App\Http\Controllers\AdminController::class, 'admin_simpan']);
	Route::get('konfigurasi/admin/edit/{id}', [App\Http\Controllers\AdminController::class, 'admin_edit']);
	Route::post('konfigurasi/admin/update', [App\Http\Controllers\AdminController::class, 'admin_update']);
	Route::post('konfigurasi/admin/sitelist', [App\Http\Controllers\AdminController::class, 'sitelist']);
	Route::post('konfigurasi/admin/addsiteuser', [App\Http\Controllers\AdminController::class, 'addsite']);
	Route::post('konfigurasi/admin/deleteusersite', [App\Http\Controllers\AdminController::class, 'deletesite']);
	Route::post('konfigurasi/admin/log_login', [App\Http\Controllers\AdminController::class, 'log_login']);
	
	//tiket
	Route::get('konfigurasi/tiket', [App\Http\Controllers\TiketController::class, 'index']);
	Route::get('konfigurasi/tiket/add', [App\Http\Controllers\TiketController::class, 'add']);
	Route::post('konfigurasi/tiket/simpan', [App\Http\Controllers\TiketController::class, 'simpan']);
	Route::get('konfigurasi/tiket/edit/{id}', [App\Http\Controllers\TiketController::class, 'edit']);
	Route::post('konfigurasi/tiket/update', [App\Http\Controllers\TiketController::class, 'update']);
	Route::post('konfigurasi/tiket/delete', [App\Http\Controllers\TiketController::class, 'delete']);
	
	//merk dan warna mobil
	Route::get('konfigurasi/mobil/{id}', [App\Http\Controllers\MobilController::class, 'index']);
	Route::get('konfigurasi/mobil/{id}/add', [App\Http\Controllers\MobilController::class, 'add']);
	Route::post('konfigurasi/mobil/add', [App\Http\Controllers\MobilController::class, 'simpan']);
	Route::get('konfigurasi/mobil/{id}/edit/{opt}', [App\Http\Controllers\MobilController::class, 'edit']);
	Route::post('konfigurasi/mobil/update', [App\Http\Controllers\MobilController::class, 'update']);
	
		
	//devices
	Route::get('konfigurasi/devices', [App\Http\Controllers\DeviceController::class, 'index']);
	Route::get('konfigurasi/devices/add', [App\Http\Controllers\DeviceController::class, 'devices_add']);
	Route::post('konfigurasi/devices/simpan', [App\Http\Controllers\DeviceController::class, 'devices_simpan']);
	Route::get('konfigurasi/devices/edit/{id}', [App\Http\Controllers\DeviceController::class, 'devices_edit']);
	Route::get('konfigurasi/devices/detail/{id}', [App\Http\Controllers\DeviceController::class, 'devices_detail']);
	Route::post('konfigurasi/devices/update', [App\Http\Controllers\DeviceController::class, 'devices_update']);
	Route::post('konfigurasi/devices/delete', [App\Http\Controllers\DeviceController::class, 'devices_delete']);
	
});