<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Validator;

class PaketController extends Controller
{
    function index(){
		$title ="Paket dan Tarif";
		$data = DB::table("casualcharges")
		->leftJoin("master_site","master_site.siteid","=","casualcharges.site_id")
		->select("master_site.sitename","casualcharges.*")
		->get();
		return view('konfigurasi/paket/index', compact('data','title'));
	}
	
	function paket_add(){
		$title  = "Tambah Data Paket";
		$site_id = DB::table("master_site")->get();
		return view('konfigurasi/paket/add', compact('title','site_id'));
		
	}
	function paket_simpan(Request $r){
		$validator = Validator::make($r->all(), [
            'vehicle_name' => 'required|max:255',
			'charge_type' => 'required|max:255',
			'group1_charge' => 'required|max:255',
			'group2_charge' => 'required|max:255'
        ]);
		if ($validator->fails()) {
            return redirect('konfigurasi/paket/add')
                        ->withErrors($validator)
                        ->withInput();
        }
		
		$count = DB::table("casualcharges")
		->where("site_id",$r->siteid)
		->where("vehicle_name",$r->vehicle_name)
		->count();
		
		if($count > 0){
			return redirect('konfigurasi/paket/add')->with(['warning' => 'Paket site '.$r->siteid.' dengan kode '.$r->vehicle_name.' sudah terdaftar!']);;
		}
		
		
		DB::table('casualcharges')->insert([
			'site_id' => $r->siteid,
			'vehicle_name' => $r->vehicle_name,
			'startdate' => date('Y-m-d'),
			'charge_type' => $r->charge_type,
			'group1_charge' => $r->group1_charge,
			'group2_charge' => $r->group2_charge,
			'lt_charge' => $r->lt_charge,
			]);
			
		return redirect('konfigurasi/paket')->with(['success' => 'Data berhasil disimpan']);;
	}
	function paket_edit($id){
		$title  = "Edit Data Paket";
		//$site_id = Session('site_id');
		$data = DB::table("casualcharges")->where("id",$id)->first();
		return view('konfigurasi/paket/edit', compact('data','title'));
		
	}
	
	function paket_update(Request $r){
		$validator = Validator::make($r->all(), [
            'vehicle_name' => 'required|max:255',
			'charge_type' => 'required|max:255',
			'group1_charge' => 'required|max:255',
			'group2_charge' => 'required|max:255',
			'lt_charge' => 'required|max:255'
        ]);
		if ($validator->fails()) {
            return redirect('konfigurasi/paket/edit/'.$r->id_paket)
                        ->withErrors($validator)
                        ->withInput();
        }
		
		$count = DB::table("casualcharges")
		->where("site_id",$r->siteid)
		->where("vehicle_name",$r->vehicle_name)
		->where("id","<>",$r->id_paket)
		->count();
		
		//dd($count);
		
		if($count > 0){
			return redirect('konfigurasi/paket/edit/'.$r->id_paket)->with(['warning'=>'Paket site '.$r->siteid.' dengan kode '.$r->vehicle_name.' sudah terdaftar!']);;
		}
		
		
		DB::table('casualcharges')
		->where("id",$r->id_paket)
		->update([
			'site_id' => $r->siteid,
			'vehicle_name' => $r->vehicle_name,
			'charge_type' => $r->charge_type,
			'group1_charge' => $r->group1_charge,
			'group2_charge' => $r->group2_charge,
			'lt_charge' => $r->lt_charge,
			]);
			
		return redirect('konfigurasi/paket')->with(['success' => 'Data berhasil disimpan']);;
	}
}
