<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Validator;

class MobilController extends Controller
{
    function index($opt){
		
		if($opt == "brand"){
			$title ="Merk Mobil";
			$data = DB::table("vehicle_brand")
			->select("id","brand_name as data")
			->orderBy('brand_name',"ASC")
			->get();
		}
		else{
			$title ="Warna Mobil";
			$data = DB::table("vehicle_color")
			->select("id","color as data")
			->get();
		}
		return view('konfigurasi/mobil/index', compact('data','title','opt'));
	}
	
		
	function add($opt){
		if($opt == "brand"){
			$title  = "Tambah Data Merk Mobil";
		}
		else{
			$title  = "Tambah Data Warna Mobil";
		}
		return view('konfigurasi/mobil/add', compact('title','opt'));		
	}
	function simpan(Request $r){
		$validator = Validator::make($r->all(), [
            'data' => 'required|max:255',
		]);
		
		if ($validator->fails()) {
            return redirect('konfigurasi/mobil/add/'.$r->opt)
                 ->withErrors($validator)
                 ->withInput();
        }
		
		if($r->opt == "brand"){
			$rs = DB::table("vehicle_brand")
			->where("brand_name",$r->data)
			->count();
		}
		else{
			$rs = DB::table("vehicle_color")
			->where("color",$r->data)
			->count();
		}
		 
		if($rs > 0){
			return redirect('konfigurasi/mobil/add/'.$r->opt)->with('warning','Data sudah terdaftar!');
		}
		
		if($r->opt == "brand"){
			DB::table('vehicle_brand')->insert([
				'brand_name' => $r->data,
				]);
		}
		else{
			DB::table('vehicle_color')->insert([
				'color' => $r->data,
				]);
		}
			
		return redirect('konfigurasi/mobil/'.$r->opt)->with('success','Data berhasil disimpan');
	}
	
	
	function edit($opt,$id){
		if($opt == "brand"){
			$title  = "Edit Data Jenis Mobil";
			$data = DB::table("vehicle_brand")->select("id","brand_name as data")->where("id",$id)->first();
		}
		else{
			$title  = "Edit Data Warna Mobil";
			$data = DB::table("vehicle_color")->select("id","color as data")->where("id",$id)->first();
		}
		
		return view('konfigurasi/mobil/edit', compact('data','title','opt'));
		
	}
	
	function update(Request $r){
		$validator = Validator::make($r->all(), [
            'data' => 'required|max:255',
        ]);
		if ($validator->fails()) {
            return redirect('konfigurasi/mobil/edit/'.$r->opt.'/'.$r->id)
                        ->withErrors($validator)
                        ->withInput();
        }
		if($r->opt == "brand"){
			DB::table('vehicle_brand')
			->where("id",$r->id)
			->update([
				'brand_name' => $r->data,
			]);
		}
		else{
			DB::table('vehicle_color')
			->where("id",$r->id)
			->update([
				'color' => $r->data,
			]);
		}
		
			
		return redirect('konfigurasi/mobil/'.$r->opt)->with(['success' => 'Data berhasil disimpan']);
		
	}
	
	function remove(Request $r){
		if($r->opt == "brand"){
			DB::table('vehicle_brand')
			->where("id",$r->id)
			->delete();
		}
		else{
			DB::table('vehicle_color')
			->where("id",$r->id)
			->delete();
		}
	}
}
