<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Validator;


class LobbyController extends Controller
{
    function index(){
		$title ="Lobby";
		
		$data = DB::table("master_lobby")
		->leftJoin("master_site","master_site.siteid","=","master_lobby.site_id")
		->select("master_site.sitename","master_lobby.*")
		->get();
		return view('konfigurasi/lobby/index', compact('data','title'));
	}
	
	function lobby_add(){
		$title  = "Tambah Data Lobby";
		$site_id = DB::table("master_site")->get();
		return view('konfigurasi/lobby/add', compact('title','site_id'));
		
	}
	
	function lobby_simpan(Request $r){
		$validator = Validator::make($r->all(), [
            'siteid' => 'required|max:255',
			'lobby_name' => 'required|max:255',
        ]);
		if ($validator->fails()) {
            return redirect('konfigurasi/lobby/add')
                        ->withErrors($validator)
                        ->withInput();
        }
		DB::table('master_lobby')->insert([
			'site_id' => $r->siteid,
			'lobby_name' => $r->lobby_name,
			]);
		return redirect('konfigurasi/lobby')->with('success','Data berhasil disimpan');
	}
	
	function lobby_edit($id){
		$title  = "Edit Data Lobby";
		$data = DB::table("master_lobby")->where("id",$id)->first();
		return view('konfigurasi/lobby/edit', compact('data','title'));
		
	}
	
	function lobby_update(Request $r){
		$validator = Validator::make($r->all(), [
            'siteid' => 'required|max:255',
            'lobby_name' => 'required|max:255',	
        ]);
		if ($validator->fails()) {
            return redirect('konfigurasi/lobby/add')
                        ->withErrors($validator)
                        ->withInput();
        }
		DB::table('master_lobby')
		->where("id",$r->id_lobby)
		->update([
			'site_id' => $r->siteid,
			'lobby_name' => $r->lobby_name,
			]);
			//return redirect('konfigurasi/lobby');
		return redirect('konfigurasi/lobby')->with(['success' => 'Data berhasil disimpan']);;
	}
}
