<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Auth;
use Hash;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
		$data['title'] = "DASHBOARD";
		
		//volume masuk
		if(Auth::user()->akses == "SUPERUSER"){
			$query = "parking_in.site_id <> '' ";
		}
		else{
			$query = "parking_in.site_id in (select siteid from users_sites where userid= '".Auth::user()->email."') "; 
		}
		
		if(Auth::user()->akses == "SUPERUSER"){
			$rekap = DB::table("parking_in")
				->leftJoin("master_site","master_site.siteid","=","parking_in.site_id")
				->select("master_site.siteid","master_site.sitename")
				->selectRaw('count(ti_key) as cnt')
				->groupBy("master_site.siteid","master_site.sitename")
				->get();
			
		}
		else{
			$rekap = DB::table("parking_in")
				->leftJoin("master_site","master_site.siteid","=","parking_in.site_id")
				->select("master_site.siteid","master_site.sitename")
				->whereRAW($query)
				->selectRaw('count(ti_key) as cnt')
				->groupBy("master_site.siteid","master_site.sitename")
				->where("flag",0)->get();
		}
		
		$html = "";
		$a=array("warning","success","danger","primary","secondary");
		$random_keys=array_rand($a,5);
		$i = 0;
		foreach($rekap as $r){
			$i++;
			if($i == 5){
				$i = 0;
			}
			$html .= '
			
			  <div class="col-xl-3 col-lg-6 col-md-6 col-12">
				<div class="card bg-'.$a[$random_keys[$i]].'">
				  <div class="card-content">
					<div class="card-body pt-2 pb-0">
					  <div class="media">
						<div class="media-body white text-left">
						  <span>'.$r->sitename.'</span>
						  <h3 class="font-large-1 mb-0">'.number_format($r->cnt).'</h3>
						</div>
						
					  </div>';
					 
					$html .= '
					
				  </div><Br>
				  </div>
				</div>
			  </div>
			';
		}
		$data['volume'] = $html;
		
		//revenue
		
		$date = date('Y-m-d');
		if(Auth::user()->akses == "SUPERUSER"){
			$query = "parking_out_mobile.site_id <> '' ";
		}
		else{
			$query = "parking_out_mobile.site_id in (select siteid from users_sites where userid= '".Auth::user()->email."') "; 
		}
		
		if(Auth::user()->akses == "SUPERUSER"){
			$rekap = DB::table("parking_out_mobile")
				->leftJoin("master_site","master_site.siteid","=","parking_out_mobile.site_id")
				->select("master_site.siteid","master_site.sitename")
				->selectRaw('count(qrcode) as cnt, sum(parking_fee) as amt')
				->whereRaw("left(datetimeout,10) = '$date'")
				->groupBy("master_site.siteid","master_site.sitename")
				->get();
			
		}
		else{
			$rekap = DB::table("parking_out_mobile")
				->leftJoin("master_site","master_site.siteid","=","parking_out_mobile.site_id")
				->select("master_site.siteid","master_site.sitename")
				->whereRAW($query)
				->selectRaw('count(qrcode) as cnt, sum(parking_fee) as amt')
				->whereRaw("left(datetimeout,10) = '$date'")
				->where("flag",0)
				->groupBy("master_site.siteid","master_site.sitename")
				->get();
				
		}
		//dd($rekap);
		$html = "";
		if($rekap == "[]"){
			$html .= "<div class='card-body'><p class='danger'>Data income tidak tersedia</p></div>";
		}
		else{
			
		
			$a=array("warning","success","danger","primary","secondary");
			$random_keys=array_rand($a,5);
			$i = 0;
			foreach($rekap as $r){
				$i++;
				if($i == 5){
					$i = 0;
				}
				$html .= '
				
				  <div class="col-xl-3 col-lg-6 col-md-6 col-12">
					<div class="card bg-'.$a[$random_keys[$i]].'">
					  <div class="card-content">
						<div class="card-body pt-2 pb-0">
						  <div class="media">
							<div class="media-body white text-left">
							  <span>'.$r->sitename.'</span>
							  <div class="text-right">
							  <h5 mb-0 text-right"><i class="fa fa-car"></i> : '.number_format($r->cnt).'</h5>
							  <h5 mb-0"><i class="fa fa-money"></i> : '.number_format($r->amt).'</h5>
							  </div>
							</div>
							
						  </div>';
						 
						$html .= '
						
					  </div><Br>
					  </div>
					</div>
				  </div>
				';
			}
		}
		$data['revenue'] = $html;
		
		
        return view('home',$data);
    }
	
	function profile(){
		
		$data['title'] = "My Profile";
		
		return view('auth/profile',$data);
 	}
	
	function profile_update(Request $r){
		
		$userid = $r->userid;
		$email = $r->email;
		$fullname = $r->fullname;
		
		if($r->password != ""){
			if($r->password_old == ""){
				return redirect('profile')->with(['warning' => 'Silakan isi password lama anda!']);
			}
			else{
				
				$data = DB::table("users")->where("email",$email)->first();
				
				$password_lama = $r->password_old;
				$password_baru1 = $r->password;
				$password_baru2 = $r->password2;
				if($password_baru1 == "" || $password_baru2 == ""){
					return redirect('profile')->with(['warning' => 'Silakan lengkapi password baru anda!']);
				}
				elseif($password_baru1 !=  $password_baru2){
					return redirect('profile')->with(['warning' => 'Password baru tidak sama!']);
				}
				else{
					if(!Hash::check($password_lama, $data->password)) {
						return redirect('profile')->with(['warning' => 'Password lama anda tidak sesuai!']);
					}
					else{
						$update = DB::table("users")
						->where("email","=",$email)
						->update(["password"=>Hash::make($password_baru1)]);
						
						return redirect('profile')->with(['info' => 'Profile berhasil diubah!']);
					}
				}
			}
		}
		else{
			$update = DB::table("users")
			->where("email","=",$email)
			->update(["fullname"=>$fullname]);
			
			return redirect('profile')->with(['info' => 'Profile berhasil diupdate!']);
		}
		
		
 	}
}
