<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use Validator;
use DB;

class LoginController extends Controller
{
   public function login()
    {
		//return "test";
      return view('auth/login');
    }

    public function authenticate(Request $request)
    {
        $request->validate([
            'email' => 'required|string|email',
            'password' => 'required|string',
        ]);

        $credentials = $request->only('email', 'password');

        if (Auth::attempt($credentials)) {
			$this->saveLog($request->email);
            return redirect()->intended('home');
        }

        return redirect('login')->with('error', 'Opps! You have entered invalid credentials');
    }

    public function logout() {
      Auth::logout();

      return redirect('login');
    }
	
	function saveLog($email){
		DB::table("log_login")->insert(["userid"=>$email]);
	}
	
	function showLoginForm (){
		return view('auth/login');
	}
}
